/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IQuickFixProcessorsRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;

public class QuickFixProcessorsRegistry
implements IQuickFixProcessorsRegistry {
    private static final String EXTENSION_POINT_ID = "quickFixProcessors";
    private static final String ELEMENT_TYPE = "processor";
    private Map<String, LazyQuickFixProcessor> processorsMap;

    public synchronized IQuickAssistProcessor getQuickFixProcessor(String contentType) {
        if (StringUtil.isEmpty((String)contentType)) {
            return null;
        }
        IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)("GetQuickFixProcessor:" + contentType));
        this.lazyLoad();
        LazyQuickFixProcessor processor = this.processorsMap.get(contentType);
        if (processor != null) {
            return processor.getQuickFixProcessor();
        }
        return null;
    }

    protected IExtensionPoint getExtensionPoint() {
        return EclipseUtil.getExtensionPoint((String)"com.aptana.editor.common", (String)EXTENSION_POINT_ID);
    }

    private synchronized void lazyLoad() {
        if (this.processorsMap == null) {
            IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)"lazyload");
            final ArrayList temp = new ArrayList();
            IExtensionPoint extensionPoint = this.getExtensionPoint();
            EclipseUtil.processElements((IExtensionPoint)extensionPoint, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    String elementName = element.getName();
                    if (QuickFixProcessorsRegistry.ELEMENT_TYPE.equals(elementName)) {
                        temp.add(new LazyQuickFixProcessor(element));
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{QuickFixProcessorsRegistry.ELEMENT_TYPE});
                }
            });
            this.processorsMap = CollectionsUtil.mapFromValues(temp, (IMap)new IMap<LazyQuickFixProcessor, String>(){

                public String map(LazyQuickFixProcessor item) {
                    return item.getContentType();
                }
            });
        }
    }

    class LazyQuickFixProcessor {
        private static final String ATTR_CLASS = "class";
        private static final String ATTR_CONTENT_ID = "contentType";
        private IConfigurationElement element;
        private IQuickAssistProcessor wrapped;

        public LazyQuickFixProcessor(IConfigurationElement element) {
            this.element = element;
        }

        public String getContentType() {
            return this.element.getAttribute(ATTR_CONTENT_ID);
        }

        public IQuickAssistProcessor getQuickFixProcessor() {
            if (this.wrapped == null) {
                try {
                    this.wrapped = (IQuickAssistProcessor)this.element.createExecutableExtension(ATTR_CLASS);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
            return this.wrapped;
        }
    }
}

